/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.tls;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.tls.PrivateKeyParser;

public final class ContextProvider {
    private static final Logger LOGGER = Logger.getLogger(ContextProvider.class.getName());
    private static final ContextProvider INSTANCE = new ContextProvider();
    private final SecureRandom random = new SecureRandom();
    private final Map<DockerInstance, ContextHolder> cache = new WeakHashMap<DockerInstance, ContextHolder>();

    private ContextProvider() {
    }

    public static ContextProvider getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext getSSLContext(DockerInstance instance) {
        ContextProvider contextProvider = this;
        synchronized (contextProvider) {
            SSLContext context;
            ContextHolder holder;
            File keyFile;
            File certificateFile;
            File caCertificateFile;
            block13: {
                caCertificateFile = instance.getCaCertificateFile();
                certificateFile = instance.getCertificateFile();
                keyFile = instance.getKeyFile();
                holder = this.cache.get(instance);
                if (holder != null && Objects.equals(holder.getCaCertificateFile(), caCertificateFile) && Objects.equals(holder.getCertificateFile(), certificateFile) && Objects.equals(holder.getKeyFile(), keyFile)) {
                    LOGGER.log(Level.FINE, "SSLContext cache hit");
                    return holder.getContext();
                }
                try {
                    try {
                        if (caCertificateFile == null && certificateFile == null && keyFile == null) {
                            context = SSLContext.getInstance("TLS");
                            break block13;
                        }
                        if (certificateFile == null && keyFile != null) {
                            LOGGER.log(Level.INFO, "Certificate file is null; ignoring key file");
                            context = this.createSSLContext(caCertificateFile, null, null);
                        }
                        if (certificateFile != null && keyFile == null) {
                            LOGGER.log(Level.INFO, "Key file is null; ignoring certificate file");
                            context = this.createSSLContext(caCertificateFile, null, null);
                            break block13;
                        }
                        context = this.createSSLContext(caCertificateFile, certificateFile, keyFile);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                        context = SSLContext.getInstance("TLS");
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    try {
                        context = SSLContext.getInstance("TLSv1");
                    }
                    catch (NoSuchAlgorithmException ex1) {
                        throw new UnknownError("Platform does not support TLSv1 required by spec");
                    }
                }
            }
            holder = new ContextHolder(caCertificateFile, certificateFile, keyFile, context);
            this.cache.put(instance, holder);
            return context;
        }
    }

    private SSLContext createSSLContext(File caCert, File clientCert, File clientKey) throws IOException {
        assert (clientCert != null && clientKey != null || clientCert == null && clientKey == null);
        try {
            Certificate caCertObject;
            char[] keyStorePassword = new BigInteger(130, this.random).toString(32).toCharArray();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(caCert));){
                caCertObject = cf.generateCertificate(is);
            }
            Certificate clientCertObject = null;
            if (clientCert != null) {
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(clientCert));){
                    clientCertObject = cf.generateCertificate(is);
                }
            }
            PrivateKey clientKeyObject = null;
            if (clientKey != null) {
                clientKeyObject = new PrivateKeyParser(clientKey).parse();
            }
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            trustStore.setEntry("ca", new KeyStore.TrustedCertificateEntry(caCertObject), null);
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init(trustStore);
            KeyManagerFactory kmfactory = null;
            if (clientCertObject != null && clientKeyObject != null) {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                keyStore.setCertificateEntry("client", clientCertObject);
                keyStore.setKeyEntry("key", clientKeyObject, keyStorePassword, new Certificate[]{clientCertObject});
                kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(keyStore, keyStorePassword);
            }
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(kmfactory != null ? kmfactory.getKeyManagers() : null, tmfactory.getTrustManagers(), null);
            return context;
        }
        catch (GeneralSecurityException ex) {
            throw new IOException(ex);
        }
    }

    private static class ContextHolder {
        private final File caCertificateFile;
        private final File certificateFile;
        private final File keyFile;
        private final SSLContext context;

        public ContextHolder(File caCertificateFile, File certificateFile, File keyFile, SSLContext context) {
            this.caCertificateFile = caCertificateFile;
            this.certificateFile = certificateFile;
            this.keyFile = keyFile;
            this.context = context;
        }

        public File getCaCertificateFile() {
            return this.caCertificateFile;
        }

        public File getCertificateFile() {
            return this.certificateFile;
        }

        public File getKeyFile() {
            return this.keyFile;
        }

        public SSLContext getContext() {
            return this.context;
        }
    }
}

